/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorListener;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.registry.ICraftingTaskFactory;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.CraftingTaskError;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.MasterCraftingTask;
import com.raoulvdberge.refinedstorage.tile.TileController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingManager
implements ICraftingManager {
    private static final int THROTTLE_DELAY_MS = 3000;
    private static final Logger LOGGER = LogManager.getLogger(CraftingManager.class);
    private static final String NBT_TASKS = "Tasks";
    private static final String NBT_TASK_TYPE = "Type";
    private static final String NBT_TASK_DATA = "Task";
    private final TileController network;
    private final Map<String, List<IItemHandlerModifiable>> containerInventories = new LinkedHashMap<String, List<IItemHandlerModifiable>>();
    private final Map<ICraftingPattern, Set<ICraftingPatternContainer>> patternToContainer = new HashMap<ICraftingPattern, Set<ICraftingPatternContainer>>();
    private final Set<ICraftingPattern> patterns = new HashSet<ICraftingPattern>();
    private final Map<UUID, ICraftingTask> tasks = new LinkedHashMap<UUID, ICraftingTask>();
    private final List<UUID> tasksToCancel = new ArrayList<UUID>();
    private final List<ICraftingTask> tasksInCalculation = new ArrayList<ICraftingTask>();
    private final Map<Object, Long> throttledRequesters = new HashMap<Object, Long>();
    private final Set<ICraftingMonitorListener> listeners = new HashSet<ICraftingMonitorListener>();
    private NBTTagList tasksToRead;
    private boolean tasksDirty;

    public CraftingManager(TileController network) {
        this.network = network;
    }

    @Override
    public void update() {
        ICraftingTask task;
        if (this.tasksDirty || this.network.func_145831_w().func_72820_D() % 20L == 0L) {
            this.listeners.forEach(ICraftingMonitorListener::onChanged);
            this.tasksDirty = false;
        }
        if (this.tasksToRead != null) {
            for (int i = 0; i < this.tasksToRead.func_74745_c(); ++i) {
                NBTTagCompound taskTag = this.tasksToRead.func_150305_b(i);
                String taskType = taskTag.func_74779_i(NBT_TASK_TYPE);
                NBTTagCompound taskData = taskTag.func_74775_l(NBT_TASK_DATA);
                ICraftingTaskFactory factory = API.instance().getCraftingTaskRegistry().get(taskType);
                if (factory == null) continue;
                try {
                    LOGGER.debug("Reading task...");
                    MasterCraftingTask task2 = factory.createFromNbt(this.network, taskData);
                    this.tasks.put(task2.getId(), task2);
                    LOGGER.debug("Loaded task with id {}", (Object)task2.getId());
                    continue;
                }
                catch (CraftingTaskReadException e) {
                    LOGGER.catching((Throwable)e);
                }
            }
            this.tasksToRead = null;
        }
        boolean changed = !this.tasksToCancel.isEmpty();
        for (UUID idToCancel : this.tasksToCancel) {
            task = this.tasks.get(idToCancel);
            if (task == null) continue;
            task.onCancelled();
            this.tasks.remove(idToCancel);
        }
        this.tasksToCancel.clear();
        boolean anyFinished = false;
        Iterator<Map.Entry<UUID, ICraftingTask>> it = this.tasks.entrySet().iterator();
        while (it.hasNext()) {
            task = it.next().getValue();
            if (task.isHalted() || !task.canUpdate() || !task.update()) continue;
            anyFinished = true;
            it.remove();
            task.onCancelled();
        }
        if (changed || anyFinished) {
            this.onTaskChanged();
        }
        if (!this.tasks.isEmpty()) {
            this.network.markNetworkNodeDirty();
        }
    }

    @Override
    public void onTaskChanged() {
        this.tasksDirty = true;
    }

    @Override
    public NBTTagCompound writeToNbt(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (ICraftingTask task : this.tasks.values()) {
            NBTTagCompound taskTag = new NBTTagCompound();
            taskTag.func_74778_a(NBT_TASK_TYPE, task.getPattern().getId());
            taskTag.func_74782_a(NBT_TASK_DATA, (NBTBase)task.writeToNbt(new NBTTagCompound()));
            list.func_74742_a((NBTBase)taskTag);
        }
        tag.func_74782_a(NBT_TASKS, (NBTBase)list);
        return tag;
    }

    @Override
    public void readFromNbt(NBTTagCompound tag) {
        this.tasksToRead = tag.func_150295_c(NBT_TASKS, 10);
    }

    @Override
    public void add(@Nonnull ICraftingTask task) {
        this.tasks.put(task.getId(), task);
        this.network.markNetworkNodeDirty();
    }

    @Override
    public void cancel(@Nullable UUID id) {
        if (id == null) {
            this.tasksToCancel.addAll(this.tasks.keySet());
        } else {
            this.tasksToCancel.add(id);
        }
        this.network.markNetworkNodeDirty();
    }

    @Override
    public void addListener(ICraftingMonitorListener listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(ICraftingMonitorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    @Nullable
    public ICraftingTask request(Object source, ItemStack stack, long amount) {
        if (this.isThrottled(source)) {
            return null;
        }
        for (ICraftingTask task : this.getTasks()) {
            if (task.getRequested().getItem() == null || !API.instance().getComparer().isEqualNoQuantity(task.getRequested().getItem(), stack)) continue;
            amount -= task.getQuantity();
        }
        if (amount <= 0L) {
            return null;
        }
        for (ICraftingTask task : this.tasksInCalculation) {
            if (task.getRequested().getItem() == null || !API.instance().getComparer().isEqualNoQuantity(task.getRequested().getItem(), stack)) continue;
            amount -= task.getQuantity();
        }
        if (amount <= 0L) {
            return null;
        }
        ICraftingTask task = this.create(stack, amount);
        if (task != null) {
            this.addAndCalculateTask(source, task);
            return task;
        }
        this.throttle(source);
        return null;
    }

    @Override
    @Nullable
    public ICraftingTask request(Object source, FluidStack stack, long amount) {
        if (this.isThrottled(source)) {
            return null;
        }
        for (ICraftingTask task : this.getTasks()) {
            if (task.getRequested().getFluid() == null || !API.instance().getComparer().isEqual(task.getRequested().getFluid(), stack, 2)) continue;
            amount -= task.getQuantity();
        }
        if (amount <= 0L) {
            return null;
        }
        for (ICraftingTask task : this.tasksInCalculation) {
            if (task.getRequested().getFluid() == null || !API.instance().getComparer().isEqual(task.getRequested().getFluid(), stack, 2)) continue;
            amount -= task.getQuantity();
        }
        if (amount <= 0L) {
            return null;
        }
        ICraftingTask task = this.create(stack, amount);
        if (task != null) {
            this.addAndCalculateTask(source, task);
            return task;
        }
        this.throttle(source);
        return null;
    }

    private void addAndCalculateTask(Object source, ICraftingTask task) {
        this.tasksInCalculation.add(task);
        ((CompletableFuture)CompletableFuture.supplyAsync(task::calculate).exceptionally(t -> {
            t.printStackTrace();
            task.onCancelled();
            return new CraftingTaskError();
        })).thenAccept(err -> FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
            if (err == null && !task.hasMissing()) {
                this.add(task);
                task.setCanUpdate(true);
            } else {
                this.throttle(source);
            }
            this.tasksInCalculation.remove(task);
        }));
    }

    @Override
    @Nullable
    public ICraftingTask create(ItemStack stack, long quantity) {
        ICraftingTaskFactory factory;
        ICraftingPattern pattern = this.getPattern(stack);
        if (pattern == null) {
            return null;
        }
        String id = pattern.getId();
        if (id.equals("normal")) {
            id = "v8";
        }
        if ((factory = API.instance().getCraftingTaskRegistry().get(id)) == null) {
            return null;
        }
        return factory.create(this.network, API.instance().createCraftingRequestInfo(stack, quantity), pattern);
    }

    @Override
    @Nullable
    public ICraftingTask create(FluidStack stack, long quantity) {
        ICraftingPattern pattern = this.getPattern(stack);
        if (pattern == null) {
            return null;
        }
        ICraftingTaskFactory factory = API.instance().getCraftingTaskRegistry().get(pattern.getId());
        if (factory == null) {
            return null;
        }
        return factory.create(this.network, API.instance().createCraftingRequestInfo(stack, quantity), pattern);
    }

    @Override
    public void track(ItemStack stack) {
        int trackedAmount = 0;
        int oldStackSize = stack.func_190916_E();
        for (ICraftingTask task : this.tasks.values()) {
            if (!task.canUpdate()) continue;
            trackedAmount = task.onTrackedInsert(stack, trackedAmount);
            if (!stack.func_190926_b()) continue;
            break;
        }
        this.tasksDirty |= trackedAmount > 0 || oldStackSize != stack.func_190916_E();
    }

    @Override
    public void track(FluidStack stack) {
        int trackedAmount = 0;
        int oldStackSize = stack.amount;
        for (ICraftingTask task : this.tasks.values()) {
            if (!task.canUpdate()) continue;
            trackedAmount = task.onTrackedInsert(stack, trackedAmount);
            if (stack.amount >= 1) continue;
            break;
        }
        this.tasksDirty |= trackedAmount > 0 || oldStackSize != stack.amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuild() {
        this.network.getItemStorageCache().getCraftablesList().clearCounts();
        this.network.getFluidStorageCache().getCraftablesList().clearCounts();
        Set<ICraftingPattern> set = this.patterns;
        synchronized (set) {
            this.patterns.clear();
            this.containerInventories.clear();
            this.patternToContainer.clear();
            ArrayList<ICraftingPatternContainer> containers = new ArrayList<ICraftingPatternContainer>();
            for (INetworkNode node : this.network.getNodeGraph().all()) {
                if (!(node instanceof ICraftingPatternContainer) || !node.canUpdate()) continue;
                containers.add((ICraftingPatternContainer)((Object)node));
            }
            containers.sort((a, b) -> b.getPosition().compareTo((Vec3i)a.getPosition()));
            for (ICraftingPatternContainer container : containers) {
                for (ICraftingPattern pattern : container.getPatterns()) {
                    this.patterns.add(pattern);
                    block6: for (ItemStack output : pattern.getOutputs()) {
                        for (ItemStack blacklistedItem : pattern.getBlacklistedItems()) {
                            if (!API.instance().getComparer().isEqualNoQuantity(blacklistedItem, output)) continue;
                            continue block6;
                        }
                        this.network.getItemStorageCache().getCraftablesList().add(output);
                    }
                    block8: for (ItemStack output : pattern.getFluidOutputs()) {
                        for (FluidStack blacklistedFluid : pattern.getBlacklistedFluids()) {
                            if (!API.instance().getComparer().isEqual(blacklistedFluid, (FluidStack)output, 2)) continue;
                            continue block8;
                        }
                        this.network.getFluidStorageCache().getCraftablesList().add((FluidStack)output);
                    }
                    this.patternToContainer.computeIfAbsent(pattern, key -> new LinkedHashSet()).add(container);
                }
                IItemHandlerModifiable handler = container.getPatternInventory();
                if (handler == null) continue;
                this.containerInventories.computeIfAbsent(container.getName(), k -> new ArrayList()).add(handler);
            }
        }
        this.network.getItemStorageCache().getCraftablesList().clearEmpty();
        this.network.getFluidStorageCache().getCraftablesList().clearEmpty();
        this.network.getItemStorageCache().reAttachListeners();
        this.network.getFluidStorageCache().reAttachListeners();
        for (ICraftingTask task : this.tasks.values()) {
            task.updateHaltedState();
        }
    }

    private void throttle(@Nullable Object source) {
        if (source != null) {
            this.throttledRequesters.put(source, MinecraftServer.func_130071_aq());
        }
    }

    private boolean isThrottled(@Nullable Object source) {
        if (source == null) {
            return false;
        }
        Long throttledSince = this.throttledRequesters.get(source);
        if (throttledSince == null) {
            return false;
        }
        return MinecraftServer.func_130071_aq() - throttledSince < 3000L;
    }

    @Override
    @Nullable
    public ICraftingTask getTask(UUID id) {
        return this.tasks.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ICraftingPattern getPattern(ItemStack pattern, int flags, Predicate<ICraftingPattern> filter) {
        Set<ICraftingPattern> set = this.patterns;
        synchronized (set) {
            for (ICraftingPattern patternInList : this.patterns) {
                if (!filter.test(patternInList)) continue;
                for (ItemStack output : patternInList.getOutputs()) {
                    if (!API.instance().getComparer().isEqual(output, pattern, flags) || !patternInList.getBlacklistedItems().stream().noneMatch(f -> API.instance().getComparer().isEqualNoQuantity((ItemStack)f, pattern))) continue;
                    return patternInList;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ICraftingPattern getPattern(FluidStack pattern, Predicate<ICraftingPattern> filter) {
        Set<ICraftingPattern> set = this.patterns;
        synchronized (set) {
            for (ICraftingPattern patternInList : this.patterns) {
                if (!filter.test(patternInList)) continue;
                for (FluidStack output : patternInList.getFluidOutputs()) {
                    if (!API.instance().getComparer().isEqual(output, pattern, 2) || !patternInList.getBlacklistedFluids().stream().noneMatch(f -> API.instance().getComparer().isEqual((FluidStack)f, pattern, 2))) continue;
                    return patternInList;
                }
            }
            return null;
        }
    }

    @Override
    public Set<ICraftingPatternContainer> getAllContainer(ICraftingPattern pattern) {
        return this.patternToContainer.getOrDefault(pattern, Collections.emptySet());
    }

    @Override
    public Collection<ICraftingTask> getTasks() {
        return this.tasks.values();
    }

    @Override
    public Set<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public Map<String, List<IItemHandlerModifiable>> getNamedContainers() {
        return this.containerInventories;
    }
}

